/* ============ */
/* ChiSqFrq.c	*/
/* ============ */
/* -------------------------------- */
/* WorkArea is defined in freqtst.c */
/* -------------------------------- */
#define	Freq	WorkArea
/* ====================================================== */
/* ChiSqFreq - Calculates Chi-Square Value of Frequencies */
/* ====================================================== */
void
ChiSqFreq(CHISQ_STRU * ChiSqData)
{
    ULONG   i, MaxNums, MaxSize;

    double  SosFreq = 0;

    /* ------------------------------------------ */
    /* RandFun is assumed to produce uniformly    */
    /* distributed random numbers in [0,RAND_MAX] */
    /* ------------------------------------------ */

    MaxSize = (ULONG)ChiSqData->NumElements;
    MaxNums = ChiSqData->NumVariates;

    for (i = 0; i < MaxSize; ++i)
    {
	Freq[i] = 0;
    }

    /* --------------------------------------- */
    /* Collect Data for Chi-Square Calculation */
    /* --------------------------------------- */
    for (i = 0; i < MaxNums; ++i)
    {
	int	NewRand;

	NewRand = (int)(ChiSqData->RandFun() % (int)MaxSize);
	++Freq[NewRand];
    }

    /* --------------------------- */
    /* Counting Variates Generated */
    /* --------------------------- */
    ChiSqData->TotNumGen += MaxNums;

    /* ---------------------------------------- */
    /* Calculate Sums of Squares of Frequencies */
    /* ---------------------------------------- */
    for (i = 0; i < MaxSize; ++i)
    {
        SosFreq += SQR((double) Freq[i]);
    }

    /* -------------------------- */
    /* Calculate Chi-Square Value */
    /* -------------------------- */
    ChiSqData->ChiSqValu = (SosFreq / (double) MaxNums) *
	(double) MaxSize - (double) MaxNums;

# if defined(FIND_NULLS)
    {
	UINT	Largest = 1, Smallest = RAND_MAX;
	UINT	ZeroCount = 0;

	for (i = 0; i < MaxSize; ++i)
	{
		Largest = __max(Largest, Freq[i]);
		Smallest = __min(Smallest, Freq[i]);
		if (Freq[i] == 0)
		{
			++ZeroCount;
		}
	}
	printf("ZeroCount = %u, Smallest Count = %u, Largest = %u\n",
		ZeroCount, Smallest, Largest);
    }
# endif
}
